#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/types.h>

#define EXAR_READ_REG	(FIOQSIZE + 1)
#define EXAR_WRITE_REG	(FIOQSIZE + 2)

struct xrioctl_rw_reg {
  unsigned char reg;
  unsigned char regvalue;
};

main() {
int fd; 
xrioctl_rw_reg input;

fd = open("/dev/ttyXR0", O_RDWR | O_NDELAY); // Open the serial port.

// the following code should be added AFTER any tcsetattr calls 

input.reg = 0x09; //EFR register
ioctl(fd, EXAR_READ_REG, &input); input.regvalue |= 0x10; ioctl(fd, EXAR_WRITE_REG, &input);
fprintf(stdout, "EFR set to 0x%02x \t\t bit-4 = 1 allows access to shaded bits (turn-around time bits in MSR)\n", input.regvalue);

input.reg = 0x08; //FCTR register
ioctl(fd, EXAR_READ_REG, &input); input.regvalue |= 0x20; ioctl(fd, EXAR_WRITE_REG, &input);
fprintf(stdout, "FCTR set to 0x%02x \t\t bit-5 = 1 for Auto RS-485 half-duplex mode, changes tx empty interrupt behavior\n", input.regvalue);

input.reg = 0x03; //LCR register
ioctl(fd, EXAR_READ_REG, &input); input.regvalue |= 0x80; ioctl(fd, EXAR_WRITE_REG, &input);
fprintf(stdout, "LCR set to 0x%02x \t\t bit-7 = 1 allows access to DLL, DLM and DLD\n", input.regvalue);

input.reg = 0x02; //DLD register
// RS485 control - RTS high = TX, low = RX 
// ioctl(fd, EXAR_READ_REG, &input); input.regvalue |= 0x80; ioctl(fd, EXAR_WRITE_REG, &input);  
// fprintf(stdout, "DLD set to 0x%02x \t\t bit-7 = 1 (RTS high = RX, RTS low = TX)\n", input.regvalue);

// RS485 control - RTS high = RX, low = TX
ioctl(fd, EXAR_READ_REG, &input); input.regvalue &= 0x7f; ioctl(fd, EXAR_WRITE_REG, &input);  
fprintf(stdout, "DLD set to 0x%02x \t\t bit-7 = 0 (RTS low = RX, RTS high = TX)\n", input.regvalue);

input.reg = 0x03; //LCR register
ioctl(fd, EXAR_READ_REG, &input); input.regvalue &= 0x7F; ioctl(fd, EXAR_WRITE_REG, &input);
fprintf(stdout, "LCR set to 0x%02x \t\t bit-7 = 0 disables access to DLL, DLM and DLD\n", input.regvalue);

input.reg = 0x06; //MSR register - write-only
input.regvalue = 0x80; ioctl(fd, EXAR_WRITE_REG, &input);
fprintf(stdout, "MSR set to 0x%02x \t\t bits 7-4 is turn-around delay in number of bits\n", input.regvalue);

// send 1 byte of data to see that RTS is toggling
input.reg = 0x00; //THR register
input.regvalue = 0x55; 
ioctl(fd, EXAR_WRITE_REG, &input);

close(fd);
}


